package ru.yandex.solomon.coremon.tasks.deleteMetrics;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors.Descriptor;

import ru.yandex.coremon.api.task.DeleteMetricsCheckProgress;
import ru.yandex.coremon.api.task.DeleteMetricsCheckResult;
import ru.yandex.coremon.api.task.DeleteMetricsParams;
import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.coremon.meta.service.MetabaseShard;
import ru.yandex.solomon.coremon.meta.service.MetabaseShardResolver;
import ru.yandex.solomon.scheduler.ExecutionContext;
import ru.yandex.solomon.scheduler.ProgressOperator.Ok;
import ru.yandex.solomon.scheduler.ProgressOperator.Result;
import ru.yandex.solomon.scheduler.ProgressOperator.Stop;
import ru.yandex.solomon.scheduler.Task;
import ru.yandex.stockpile.client.StockpileClient;

import static java.lang.System.currentTimeMillis;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public final class DeleteMetricsCheckTaskHandler extends AbstractDeleteMetricsTaskHandler<DeleteMetricsCheckTask> {

    static final String TYPE = "delete_metrics_check";

    private final Executor executor;
    private final ScheduledExecutorService timer;

    public DeleteMetricsCheckTaskHandler(
        DeleteMetricsTaskMetrics metrics,
        SolomonConfHolder confHolder,
        StockpileClient stockpileClient,
        MetabaseShardResolver<? extends MetabaseShard> shardResolver,
        Executor executor,
        ScheduledExecutorService timer)
    {
        super(metrics, confHolder, stockpileClient, shardResolver);
        this.executor = executor;
        this.timer = timer;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    DeleteMetricsCheckTask createTask(ExecutionContext context, DeleteMetricsParams params) {
        return new DeleteMetricsCheckTask(
            RETRY_CONFIG,
            context,
            params,
            DeleteMetricsTaskProto.checkProgress(context.task().progress()),
            executor,
            timer,
            metrics,
            confHolder,
            stockpileClient,
            shardResolver
        );
    }

    @Override
    public List<Descriptor> descriptors() {
        return List.of(
            DeleteMetricsParams.getDescriptor(),
            DeleteMetricsCheckProgress.getDescriptor(),
            DeleteMetricsCheckResult.getDescriptor());
    }

    public static Task task(DeleteMetricsParams params) {
        return Task.newBuilder()
            .setId(taskId(params))
            .setType(TYPE)
            .setExecuteAt(currentTimeMillis())
            .setParams(Any.pack(params))
            .build();
    }

    public static String taskId(DeleteMetricsParams params) {
        return params.getOperationId() + "_check_" + Integer.toUnsignedLong(params.getNumId());
    }

    public static Result interruptOperator(Any progress) {
        var prev = DeleteMetricsTaskProto.checkProgress(progress);
        if (prev.getInterrupted() || prev.getCheckNoRecentWrites().getComplete()) {
            return new Stop();
        }

        var update = prev.toBuilder()
            .setInterrupted(true)
            .build();

        return new Ok(Any.pack(update));
    }

}
