package ru.yandex.solomon.coremon.tasks.deleteMetrics;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors.Descriptor;

import ru.yandex.coremon.api.task.DeleteMetricsMoveProgress;
import ru.yandex.coremon.api.task.DeleteMetricsMoveResult;
import ru.yandex.coremon.api.task.DeleteMetricsParams;
import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.coremon.meta.db.DeletedMetricsDao;
import ru.yandex.solomon.coremon.meta.db.MetricsDaoFactory;
import ru.yandex.solomon.coremon.meta.service.MetabaseShard;
import ru.yandex.solomon.coremon.meta.service.MetabaseShardResolver;
import ru.yandex.solomon.locks.dao.LocksDao;
import ru.yandex.solomon.scheduler.ExecutionContext;
import ru.yandex.solomon.scheduler.ProgressOperator.Ok;
import ru.yandex.solomon.scheduler.ProgressOperator.Result;
import ru.yandex.solomon.scheduler.ProgressOperator.Stop;
import ru.yandex.solomon.scheduler.Task;
import ru.yandex.stockpile.client.StockpileClient;

import static java.lang.System.currentTimeMillis;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public final class DeleteMetricsMoveTaskHandler extends AbstractDeleteMetricsTaskHandler<DeleteMetricsMoveTask> {

    static final String TYPE = "delete_metrics_move";

    private final LocksDao locksDao;
    private final DeletedMetricsDao deletedMetricsDao;
    private final MetricsDaoFactory metricsDaoFactory;
    private final Executor executor;
    private final ScheduledExecutorService timer;

    public DeleteMetricsMoveTaskHandler(
        DeleteMetricsTaskMetrics metrics,
        SolomonConfHolder confHolder,
        StockpileClient stockpileClient,
        MetabaseShardResolver<? extends MetabaseShard> shardResolver,
        LocksDao locksDao,
        DeletedMetricsDao deletedMetricsDao,
        MetricsDaoFactory metricsDaoFactory,
        Executor executor,
        ScheduledExecutorService timer)
    {
        super(metrics, confHolder, stockpileClient, shardResolver);
        this.locksDao = locksDao;
        this.deletedMetricsDao = deletedMetricsDao;
        this.metricsDaoFactory = metricsDaoFactory;
        this.executor = executor;
        this.timer = timer;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    DeleteMetricsMoveTask createTask(ExecutionContext context, DeleteMetricsParams params) {
        return new DeleteMetricsMoveTask(
            RETRY_CONFIG,
            context,
            params,
            DeleteMetricsTaskProto.moveProgress(context.task().progress()),
            executor,
            timer,
            metrics,
            locksDao,
            metricsDaoFactory,
            confHolder,
            shardResolver,
            deletedMetricsDao);
    }

    @Override
    public List<Descriptor> descriptors() {
        return List.of(
            DeleteMetricsParams.getDescriptor(),
            DeleteMetricsMoveProgress.getDescriptor(),
            DeleteMetricsMoveResult.getDescriptor());
    }

    public static Task task(DeleteMetricsParams params) {
        return Task.newBuilder()
            .setId(taskId(params))
            .setType(TYPE)
            .setExecuteAt(currentTimeMillis())
            .setParams(Any.pack(params))
            .build();
    }

    public static String taskId(DeleteMetricsParams params) {
        return params.getOperationId() + "_move_" + Integer.toUnsignedLong(params.getNumId());
    }

    public static Result interruptOperator(Any progress) {
        var prev = DeleteMetricsTaskProto.moveProgress(progress);
        if (prev.getInterrupted() || prev.getReloadShard().getComplete()) {
            return new Stop();
        }

        var update = prev.toBuilder()
            .setInterrupted(true)
            .build();

        return new Ok(Any.pack(update));
    }

}
