package ru.yandex.solomon.coremon.tasks.deleteMetrics;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;

import ru.yandex.coremon.api.task.DeleteMetricsCheckProgress;
import ru.yandex.coremon.api.task.DeleteMetricsCheckResult;
import ru.yandex.coremon.api.task.DeleteMetricsMoveProgress;
import ru.yandex.coremon.api.task.DeleteMetricsMoveResult;
import ru.yandex.coremon.api.task.DeleteMetricsParams;
import ru.yandex.coremon.api.task.DeleteMetricsRollbackProgress;
import ru.yandex.coremon.api.task.DeleteMetricsRollbackResult;
import ru.yandex.coremon.api.task.DeleteMetricsTerminateProgress;
import ru.yandex.coremon.api.task.DeleteMetricsTerminateResult;

import static ru.yandex.solomon.util.Proto.unpack;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
final class DeleteMetricsTaskProto {

    private DeleteMetricsTaskProto() {
    }

    static DeleteMetricsParams params(Any params) {
        return unpack(params, DeleteMetricsParams.class);
    }

    static DeleteMetricsCheckProgress checkProgress(Any progress) {
        return unpack(progress, DeleteMetricsCheckProgress.getDefaultInstance());
    }

    static DeleteMetricsCheckResult checkResult(Any result) {
        return unpack(result, DeleteMetricsCheckResult.getDefaultInstance());
    }

    static DeleteMetricsMoveProgress moveProgress(Any progress) {
        return unpack(progress, DeleteMetricsMoveProgress.getDefaultInstance());
    }

    static DeleteMetricsMoveResult moveResult(Any result) {
        return unpack(result, DeleteMetricsMoveResult.getDefaultInstance());
    }

    static DeleteMetricsRollbackProgress rollbackProgress(Any progress) {
        return unpack(progress, DeleteMetricsRollbackProgress.getDefaultInstance());
    }

    static DeleteMetricsRollbackResult rollbackResult(Any result) {
        return unpack(result, DeleteMetricsRollbackResult.getDefaultInstance());
    }

    static DeleteMetricsTerminateProgress terminateProgress(Any progress) {
        return unpack(progress, DeleteMetricsTerminateProgress.getDefaultInstance());
    }

    static DeleteMetricsTerminateResult terminateResult(Any result) {
        return unpack(result, DeleteMetricsTerminateResult.getDefaultInstance());
    }
}
