package ru.yandex.solomon.coremon.tasks.deleteMetrics;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors.Descriptor;

import ru.yandex.coremon.api.task.DeleteMetricsParams;
import ru.yandex.coremon.api.task.DeleteMetricsTerminateProgress;
import ru.yandex.coremon.api.task.DeleteMetricsTerminateResult;
import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.coremon.meta.db.DeletedMetricsDao;
import ru.yandex.solomon.coremon.meta.service.MetabaseShard;
import ru.yandex.solomon.coremon.meta.service.MetabaseShardResolver;
import ru.yandex.solomon.scheduler.ExecutionContext;
import ru.yandex.solomon.scheduler.Task;
import ru.yandex.stockpile.client.StockpileClient;

import static java.lang.System.currentTimeMillis;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public final class DeleteMetricsTerminateTaskHandler extends AbstractDeleteMetricsTaskHandler<DeleteMetricsTerminateTask> {

    static final String TYPE = "delete_metrics_terminate";

    private final DeletedMetricsDao deletedMetricsDao;
    private final Executor executor;
    private final ScheduledExecutorService timer;

    public DeleteMetricsTerminateTaskHandler(
        DeleteMetricsTaskMetrics metrics,
        SolomonConfHolder confHolder,
        StockpileClient stockpileClient,
        MetabaseShardResolver<? extends MetabaseShard> shardResolver,
        DeletedMetricsDao deletedMetricsDao,
        Executor executor,
        ScheduledExecutorService timer)
    {
        super(metrics, confHolder, stockpileClient, shardResolver);
        this.deletedMetricsDao = deletedMetricsDao;
        this.executor = executor;
        this.timer = timer;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    DeleteMetricsTerminateTask createTask(ExecutionContext context, DeleteMetricsParams params) {
        return new DeleteMetricsTerminateTask(
            RETRY_CONFIG,
            context,
            params,
            DeleteMetricsTaskProto.terminateProgress(context.task().progress()),
            executor,
            timer,
            metrics,
            confHolder,
            shardResolver,
            deletedMetricsDao,
            stockpileClient);
    }

    @Override
    public List<Descriptor> descriptors() {
        return List.of(
            DeleteMetricsParams.getDescriptor(),
            DeleteMetricsTerminateProgress.getDescriptor(),
            DeleteMetricsTerminateResult.getDescriptor());
    }

    public static Task task(DeleteMetricsParams params) {
        return Task.newBuilder()
            .setId(params.getOperationId() + "_terminate_" + Integer.toUnsignedLong(params.getNumId()))
            .setType(TYPE)
            .setExecuteAt(currentTimeMillis())
            .setParams(Any.pack(params))
            .build();
    }

}
