package ru.yandex.solomon.coremon.tasks.deleteMetrics;

import java.util.ArrayList;
import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.coremon.meta.CoremonMetric;
import ru.yandex.solomon.coremon.meta.CoremonMetricArray;
import ru.yandex.solomon.coremon.meta.MetricsCollection;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
final class MetricsResolver {

    private MetricsResolver() {
    }

    static Collection<Labels> resolveExisting(CoremonMetricArray metrics, MetricsCollection<CoremonMetric> fileMetrics) {
        var keys = new ArrayList<Labels>(metrics.size());

        for (int i = 0; i < metrics.size(); i++) {
            var spShardId = metrics.getShardId(i);
            var localId = metrics.getLocalId(i);
            var labels = metrics.getLabels(i);

            try (var existing = fileMetrics.getOrNull(labels)) {
                if (existing != null && existing.getShardId() == spShardId && existing.getLocalId() == localId) {
                    keys.add(labels);
                }
            }
        }

        return keys;
    }
}
