package ru.yandex.solomon.coremon.tasks.deleteMetrics;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.coremon.api.task.DeleteMetricsMoveProgress.ReloadShardProgress;
import ru.yandex.coremon.api.task.DeleteMetricsParams;
import ru.yandex.solomon.coremon.meta.service.MetabaseShard;
import ru.yandex.solomon.coremon.meta.service.MetabaseShardResolver;

import static java.util.concurrent.CompletableFuture.completedFuture;
import static java.util.concurrent.CompletableFuture.failedFuture;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
final class ReloadShard implements AutoCloseable {

    private final MetabaseShardResolver<? extends MetabaseShard> shardResolver;
    private final DeleteMetricsParams params;
    private final AtomicReference<ReloadShardProgress> progress;

    ReloadShard(
        MetabaseShardResolver<? extends MetabaseShard> shardResolver,
        DeleteMetricsParams params,
        ReloadShardProgress progress)
    {
        this.shardResolver = shardResolver;
        this.params = params;
        this.progress = new AtomicReference<>(progress);
    }

    public CompletableFuture<Void> start() {
        try {
            return tryStart();
        } catch (Throwable t) {
            return failedFuture(t);
        }
    }

    public ReloadShardProgress progress() {
        return progress.get();
    }

    private CompletableFuture<Void> tryStart() {
        if (progress().getComplete()) {
            return completedFuture(null);
        }

        var shard = shardResolver.resolveShardOrNull(params.getNumId());
        if (shard == null || !shard.isLoaded()) {
            return completedFuture(null);
        }

        return shard.getStorage().reload()
            .thenRun(this::complete);
    }

    private void complete() {
        var prev = progress.get();
        if (prev.getComplete()) {
            return;
        }

        var update = ReloadShardProgress.newBuilder()
            .setComplete(true)
            .build();

        progress.compareAndSet(prev, update);
    }

    @Override
    public void close() {
    }

}
