package ru.yandex.solomon.coremon.aggregates;

import java.util.Random;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.solomon.core.db.model.MetricAggregation;
import ru.yandex.stockpile.client.shard.StockpileLocalId;
import ru.yandex.stockpile.client.shard.StockpileShardId;


/**
 * @author Sergey Polovko
 */
public class AggrMetricsTest {

    @Test
    public void packUnpack() {
        Random rnd = new Random();

        int count = 1 + rnd.nextInt(10_000);
        var shardIds = new int[count];
        var localIds = new long[count];
        var aggrs = new MetricAggregation[count];

        for (int i = 0; i < count; i++) {
            shardIds[i] = StockpileShardId.random(rnd);
            localIds[i] = StockpileLocalId.random(rnd);
            aggrs[i] = randomAggr(rnd);
        }

        int optLabelsHash = rnd.nextInt();
        int[] ids = AggrMetrics.pack(optLabelsHash, aggrs, shardIds, localIds);

        Assert.assertEquals(count, AggrMetrics.size(ids));
        Assert.assertEquals(optLabelsHash, AggrMetrics.optLabelsHash(ids));

        for (int i = 0; i < count; i++) {
            var aggr = AggrMetrics.aggr(ids, i);
            int shardId = AggrMetrics.shardId(ids, i);
            long localId = AggrMetrics.localId(ids, i);


            Assert.assertEquals(aggrs[i], aggr);
            Assert.assertEquals(shardIds[i], shardId);
            Assert.assertEquals(localIds[i], localId);
        }
    }

    private MetricAggregation randomAggr(Random random) {
        var values = MetricAggregation.values();
        return values[random.nextInt(values.length)];
    }
}
