package ru.yandex.solomon.coremon.balancer.db;

import java.util.Map;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;

/**
 * @author Sergey Polovko
 */
public class ShardAssignmentsTest {

    @Test
    public void delete() {
        var assignments = ShardAssignments.copyOf(Map.of(1, "host1", 2, "host2", 3, "host3", 4, "host4"));
        assertSame(assignments, assignments.delete(intSet()));
        assertSame(assignments, assignments.delete(intSet(5)));
        assertSame(assignments, assignments.delete(intSet(6, 7)));

        {
            var newAssignments = assignments.delete(intSet(1));
            assertEquals(ShardAssignments.copyOf(Map.of(2, "host2", 3, "host3", 4, "host4")), newAssignments);
            assertEquals(ShardAssignments.copyOf(Map.of(1, "host1", 2, "host2", 3, "host3", 4, "host4")), assignments);
        }
        {
            var newAssignments = assignments.delete(intSet(2, 3));
            assertEquals(ShardAssignments.copyOf(Map.of(1, "host1", 4, "host4")), newAssignments);
            assertEquals(ShardAssignments.copyOf(Map.of(1, "host1", 2, "host2", 3, "host3", 4, "host4")), assignments);
        }
        {
            var newAssignments = assignments.delete(intSet(4, 5));
            assertEquals(ShardAssignments.copyOf(Map.of(1, "host1", 2, "host2", 3, "host3")), newAssignments);
            assertEquals(ShardAssignments.copyOf(Map.of(1, "host1", 2, "host2", 3, "host3", 4, "host4")), assignments);
        }
    }

    private static IntSet intSet(int... values) {
        return new IntOpenHashSet(values);
    }
}
