package ru.yandex.solomon.coremon.balancer.db;

import java.util.Random;

import com.google.common.collect.ImmutableSet;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;
import static ru.yandex.misc.concurrent.CompletableFutures.join;

/**
 * @author Sergey Polovko
 */
public abstract class ShardBalancerOptionsDaoTest {

    abstract ShardBalancerOptionsDao getDao();

    @Test
    public void loadBeforeSave() {
        ShardBalancerOptions options = join(getDao().load());
        assertSame(ShardBalancerOptions.DEFAULT, options);
    }

    @Test
    public void saveAndLoad() {
        Random rnd = new Random(17);
        for (int i = 0; i < 100; i++) {
            String[] hosts = new String[rnd.nextInt(32)];
            for (int j = 0; j < hosts.length; j++) {
                hosts[j] = RandomStringUtils.randomAlphanumeric(8);
            }

            var options = new ShardBalancerOptions(
                rnd.nextLong(),
                rnd.nextInt(),
                rnd.nextDouble(),
                rnd.nextDouble(),
                rnd.nextDouble(),
                rnd.nextDouble(),
                ImmutableSet.copyOf(hosts),
                rnd.nextBoolean());

            join(getDao().save(options));

            ShardBalancerOptions fromDb = join(getDao().load());
            assertEquals(options, fromDb);
        }
    }
}
