package ru.yandex.solomon.coremon.balancer.db;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;

/**
 * @author Sergey Polovko
 */
public class YdbShardBalancerOptionsDaoTest extends ShardBalancerOptionsDaoTest {

    @ClassRule
    public static LocalKikimr kikimr = new LocalKikimr();

    @Rule
    public TestName testName = new TestName();
    private YdbHelper ydb;
    private YdbShardBalancerOptionsDao dao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(kikimr, getClass().getSimpleName() + '_' + testName.getMethodName());
        dao = new YdbShardBalancerOptionsDao(ydb.getRootPath(), ydb.getTableClient());
        join(dao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(dao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    ShardBalancerOptionsDao getDao() {
        return dao;
    }
}
