package ru.yandex.solomon.coremon.balancer.db.ydb;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.coremon.balancer.db.BalancerShardsDao;
import ru.yandex.solomon.coremon.balancer.db.BalancerShardsDaoTest;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

/**
 * @author Stanislav Kashirin
 */
public class YdbBalancerShardsDaoTest extends BalancerShardsDaoTest {

    @ClassRule
    public static final LocalKikimr kikimr = new LocalKikimr();

    @Rule
    public TestName testName = new TestName();

    private YdbHelper ydb;
    private BalancerShardsDao dao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(kikimr, this.getClass().getSimpleName() + "_" + testName.getMethodName());
        dao = new YdbBalancerShardsDao(ydb.getRootPath(), ydb.getTableClient(), ydb.getSchemeClient());
        dao.createSchemaForTests().join();
    }

    @After
    public void tearDown() {
        dao.dropSchemaForTests().join();
        ydb.close();
    }

    @Override
    protected BalancerShardsDao getDao() {
        return dao;
    }
}
