package ru.yandex.solomon.coremon.client;

import java.util.Arrays;
import java.util.Random;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * @author Sergey Polovko
 */
public class ShardAssignmentsSerializerTest {

    private final Random rnd = new Random();

    @Test
    public void serializeDeserialize() {
        String[] hosts = new String[1 + rnd.nextInt(10)];
        for (int i = 0; i < hosts.length; i++) {
            hosts[i] = RandomStringUtils.randomAlphanumeric(5);
        }

        int count = 217;
        var assignments = new Int2ObjectOpenHashMap<String>(count);

        rnd.ints(count).forEach(shardId -> {
            assignments.put(shardId, hosts[rnd.nextInt(hosts.length)]);
        });

        var response = ShardAssignmentsSerializer.toResponse(hosts, assignments);
        assertEquals(Arrays.asList(hosts), response.getHostsList());
        assertEquals(count, response.getHostIdsCount());
        assertEquals(count, response.getShardIdsCount());

        for (int i = 0; i < count; i++) {
            int shardId = response.getShardIds(i);
            int hostId = response.getHostIds(i);

            String expectedHost = assignments.get(shardId);
            String actualHost = response.getHosts(hostId);
            assertEquals(expectedHost, actualHost);
        }

        var newAssignments = ShardAssignmentsSerializer.fromResponse(response);
        assertEquals(assignments, newAssignments);
    }
}
