package ru.yandex.solomon.coremon.stockpile.write;

import java.util.concurrent.ForkJoinPool;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.coremon.stockpile.CoremonShardStockpileMetrics;
import ru.yandex.solomon.coremon.stockpile.CoremonShardStockpileWriteHelper;
import ru.yandex.solomon.metrics.client.StockpileClientStub;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;
import ru.yandex.stockpile.client.shard.StockpileLocalId;

import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.model.point.AggrPoints.point;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileBufferedWriterTest {

    private StockpileClientStub stub;
    private StockpileBufferedWriter writer;

    @Before
    public void setUp() throws Exception {
        var executor = ForkJoinPool.commonPool();
        stub = new StockpileClientStub(executor);
        stub.setShardCount(4);
        writer = new StockpileBufferedWriter(stub, executor, new MetricRegistry());
    }

    @Test
    public void writeToExistsShard() {
        int shardId = stub.randomShardId();
        long localId = StockpileLocalId.random();

        var helper = helper();
        helper.addPoint(shardId, localId, point("2019-02-01T12:10:34Z", 42), 0, MetricType.DGAUGE);
        helper.write().join();

        var expected = AggrGraphDataArrayList.of(point("2019-02-01T12:10:34Z", 42));
        var result = stub.getTimeSeries(shardId, localId).toAggrGraphDataArrayList();
        assertEquals(expected, result);
    }

    @Test
    public void increaseShardCount() {
        var point = point("2019-02-01T12:10:34Z", 42);
        var expected = AggrGraphDataArrayList.of(point);

        int shardCount = 1;
        for (int index = 0; index < 10_000; index++) {
            stub.setShardCount(shardCount++);

            int shardId = stub.randomShardId();
            long localId = StockpileLocalId.random();

            var helper = helper();
            helper.addPoint(shardId, localId, point, 0, MetricType.DGAUGE);
            helper.write().join();

            var result = stub.getTimeSeries(shardId, localId).toAggrGraphDataArrayList();
            assertEquals(expected, result);
        }
    }

    private CoremonShardStockpileWriteHelper helper() {
        var metrics = new CoremonShardStockpileMetrics(15_000, "myProjectId", "myShardId");
        return writer.newHelper(42, metrics);
    }
}
