package ru.yandex.solomon.coremon.stockpile.write;

import java.util.Random;

import com.google.common.util.concurrent.MoreExecutors;
import org.junit.Test;

import ru.yandex.solomon.codec.archive.MetricArchiveImmutable;
import ru.yandex.solomon.metrics.client.StockpileClientStub;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.stockpile.api.EDecimPolicy;
import ru.yandex.stockpile.api.EProjectId;
import ru.yandex.stockpile.client.writeRequest.StockpileShardWriteRequestBuilder;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static ru.yandex.solomon.model.point.AggrPointDataTestSupport.randomMetricType;
import static ru.yandex.solomon.model.point.AggrPointDataTestSupport.randomPoint;

/**
 * @author Sergey Polovko
 */
public class StockpileWriteQueueTest {

    private final Random rnd = new Random();

    @Test
    public void writeSingleRequest() {
        final int stockpileShardId = rnd.nextInt();
        final int coremonShardId = rnd.nextInt();
        final long localId = rnd.nextLong();

        var executor = MoreExecutors.newDirectExecutorService();
        var stockpileClient = new StockpileClientStub(executor);
        var queue = new StockpileWriteQueue(stockpileShardId, stockpileClient, executor);

        var kind = randomMetricType();
        var pointExpected = randomPoint(kind);
        var builder = new StockpileShardWriteRequestBuilder(EProjectId.SOLOMON, coremonShardId);
        builder.addRecord(localId, pointExpected, EDecimPolicy.POLICY_5_MIN_AFTER_7_DAYS_VALUE, kind);

        queue.enqueue(builder.build()).join();

        MetricArchiveImmutable timeSeries = stockpileClient.getTimeSeries(stockpileShardId, localId);
        assertNotNull(timeSeries);
        assertEquals(EProjectId.SOLOMON_VALUE, timeSeries.getOwnerProjectId());
        assertEquals(coremonShardId, timeSeries.getOwnerShardId());
        assertEquals(EDecimPolicy.POLICY_5_MIN_AFTER_7_DAYS_VALUE, timeSeries.getDecimPolicyId());
        assertEquals(1, timeSeries.getRecordCount());
        assertEquals(kind, timeSeries.getType());

        AggrPoint pointActual = new AggrPoint();
        var it = timeSeries.iterator();
        assertTrue(it.next(pointActual));
        assertEquals(pointExpected, pointActual);

        assertFalse(it.next(pointActual));
    }
}
