package ru.yandex.solomon.coremon.tasks.deleteMetrics;

import java.util.Collection;

import ru.yandex.solomon.coremon.meta.CoremonMetric;
import ru.yandex.solomon.coremon.meta.CoremonMetricHelper;

import static java.util.stream.Collectors.toUnmodifiableList;
import static org.junit.Assert.assertEquals;

/**
 * @author Stanislav Kashirin
 */
final class DeleteMetricsAssert {

    private DeleteMetricsAssert() {
    }

    static void assertMetrics(
        Collection<CoremonMetric> expectedMetrics,
        Collection<CoremonMetric> actualMetrics)
    {
        var expected = expectedMetrics.stream()
            .sorted(CoremonMetricHelper::compare)
            .collect(toUnmodifiableList());
        var actual = actualMetrics.stream()
            .sorted(CoremonMetricHelper::compare)
            .collect(toUnmodifiableList());
        assertEquals(expected, actual);
    }
}
