package ru.yandex.solomon.coremon.meta;

import javax.annotation.Nullable;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.memory.layout.MemMeasurable;


/**
 * @author Sergey Polovko
 */
public interface CoremonMetric extends AutoCloseable, MemMeasurable {

    int UNKNOWN_LAST_POINT_SECONDS = -1;

    int getShardId();
    long getLocalId();

    Labels getLabels();

    int getCreatedAtSeconds();

    MetricType getType();
    void setType(MetricType type);

    @Nullable
    Object getAggrMetrics();
    void setAggrMetrics(Object aggrMetrics);

    int getLastPointSeconds();
    void setLastPointSeconds(int lastPointSeconds);

    boolean isMemOnly();

    @Override
    void close();
}
