package ru.yandex.solomon.coremon.meta;

import org.junit.Assert;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.util.time.InstantUtils;
import ru.yandex.stockpile.client.shard.StockpileLocalId;
import ru.yandex.stockpile.client.shard.StockpileShardId;


/**
 * @author Sergey Polovko
 */
public final class CoremonMetricHelper {
    private CoremonMetricHelper() {}

    public static void assertEquals(CoremonMetric a, CoremonMetric b) {
        Assert.assertEquals(a.getShardId(), b.getShardId());
        Assert.assertEquals(a.getLocalId(), b.getLocalId());
        Assert.assertEquals(a.getLabels(), b.getLabels());
        Assert.assertEquals(a.getCreatedAtSeconds(), b.getCreatedAtSeconds());
        Assert.assertEquals(a.getType(), b.getType());
    }

    public static int compare(CoremonMetric a, CoremonMetric b) {
        int result = StockpileShardId.compare(a.getShardId(), b.getShardId());
        if (result == 0) {
            result = StockpileLocalId.compare(a.getLocalId(), b.getLocalId());
        }
        return result;
    }

    public static CoremonMetricArray metrics(Labels... labels) {
        CoremonMetricArray metrics = new CoremonMetricArray(labels.length);
        for (Labels label : labels) {
            metrics.add(1, 2, label, InstantUtils.currentTimeSeconds(), MetricType.DGAUGE);
        }
        return metrics;
    }
}
