package ru.yandex.solomon.coremon.meta;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.util.collection.CloseableIterator;
import ru.yandex.solomon.util.labelStats.LabelValuesStats;

import static java.util.Objects.requireNonNull;


/**
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
public interface MetricsCollection<Metric extends CoremonMetric> extends MemMeasurable {

    @Nullable
    Metric getOrNull(Labels key);

    boolean has(Labels key);

    CompletableFuture<Void> put(Metric metric);

    CompletableFuture<Void> putAll(CoremonMetricArray metrics);

    CompletableFuture<Void> removeAll(Collection<Labels> keys);

    /**
     * @return total number of matched metrics
     */
    default int searchMetrics(Selectors selectors, Consumer<CoremonMetric> fn) {
        return searchMetrics(selectors, 0, 0, fn);
    }

    /**
     * @return total number of matched metrics
     */
    int searchMetrics(Selectors selectors, int offset, int limit, Consumer<CoremonMetric> fn);

    /**
     * @return total number of matched metrics
     */
    default int searchLabels(Selectors selectors, Consumer<Labels> fn) {
        return searchLabels(selectors, 0, 0, fn);
    }

    /**
     * @return total number of matched metrics
     */
    int searchLabels(Selectors selectors, int offset, int limit, Consumer<Labels> fn);

    /**
     * @return total number of matched metrics
     */
    int searchCount(Selectors selectors);

    SearchIteratorResult searchIterator(Selectors selectors);

    Set<String> labelNames();

    LabelValuesStats labelStats(Set<String> requestedNames);

    long searchIndexSize();

    long searchIndexCacheSize();

    int size();

    CloseableIterator<Metric> iterator();

    default void forEach(Consumer<? super Metric> action) {
        requireNonNull(action);
        try (var it = iterator()) {
            while (it.hasNext()) {
                action.accept(it.next());
            }
        }
    }
}
