package ru.yandex.solomon.coremon.meta;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Label;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class NamedCoremonMetric {

    private final MetricType type;
    private final String name;
    private final Labels labels;
    private final int stockpileShardId;
    private final long stockpileLocalId;
    private final int createdAtSeconds;

    public NamedCoremonMetric(
        MetricType type,
        String name,
        Labels labels,
        int stockpileShardId,
        long stockpileLocalId,
        int createdAtSeconds)
    {
        this.type = type;
        this.name = name;
        this.labels = labels;
        this.stockpileShardId = stockpileShardId;
        this.stockpileLocalId = stockpileLocalId;
        this.createdAtSeconds = createdAtSeconds;
    }

    public static NamedCoremonMetric from(CoremonMetric coremonMetric) {
        return new NamedCoremonMetric(
          coremonMetric.getType(),
          "",
          coremonMetric.getLabels(),
          coremonMetric.getShardId(),
          coremonMetric.getLocalId(),
          coremonMetric.getCreatedAtSeconds());
    }

    public static NamedCoremonMetric from(CoremonMetric coremonMetric, String metricNameLabel) {
        String name = "";
        Labels labels = coremonMetric.getLabels();

        Label label = labels.findByKey(metricNameLabel);

        if (label != null) {
            name = label.getValue();
            labels = labels.removeBySameKey(label);
        }

        return new NamedCoremonMetric(
          coremonMetric.getType(),
          name,
          labels,
          coremonMetric.getShardId(),
          coremonMetric.getLocalId(),
          coremonMetric.getCreatedAtSeconds());
    }

    public MetricType getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public Labels getLabels() {
        return labels;
    }

    public int getShardId() {
        return stockpileShardId;
    }

    public long getLocalId() {
        return stockpileLocalId;
    }

    public int getCreatedAtSeconds() {
        return createdAtSeconds;
    }
}
