package ru.yandex.solomon.coremon.meta;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.util.collection.CloseableIterator;

import static java.util.Collections.emptyIterator;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public record SearchIteratorResult(CloseableIterator<CoremonMetric> iterator, int count) {

    private static final SearchIteratorResult EMPTY = new SearchIteratorResult(
        CloseableIterator.of(emptyIterator()), 0);

    public static SearchIteratorResult empty() {
        return EMPTY;
    }

}
