package ru.yandex.solomon.coremon.meta.db;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.LabelAllocator;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.coremon.meta.CoremonMetricArray;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public interface DeletedMetricsDao {

    CompletableFuture<Void> createSchema();

    /**
     * Counts metrics deleted by the operation in given shard.
     */
    CompletableFuture<Long> count(String operationId, int numId);

    /**
     * Finds a chunk of metrics deleted by the operation in given shard.
     *
     * Buffer will be cleared and completely rewritten.
     */
    CompletableFuture<Void> find(
        String operationId,
        int numId,
        int limit,
        @Nullable Labels lastKey,
        CoremonMetricArray buffer,
        LabelAllocator labelAllocator);

    /**
     * Blindly inserts metrics deleted by the operation in given shard into table using bulk upsert.
     *
     * Metrics array should not be empty.
     */
    CompletableFuture<Void> bulkUpsert(String operationId, int numId, CoremonMetricArray metrics);

    /**
     * Delete metrics deleted by the operation in given shard permanently by given keys.
     */
    CompletableFuture<Void> delete(String operationId, int numId, Collection<Labels> keys);

    /**
     * Delete a chunk of metrics deleted by the operation in given shard and return an amount.
     */
    CompletableFuture<Long> deleteBatch(String operationId, int numId);
}
