package ru.yandex.solomon.coremon.meta.db;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;

import com.google.common.collect.Multimap;

import ru.yandex.solomon.coremon.meta.CoremonMetric;
import ru.yandex.solomon.coremon.meta.CoremonMetricArray;
import ru.yandex.solomon.coremon.meta.MetricMeta;
import ru.yandex.solomon.coremon.meta.MetricsCollection;
import ru.yandex.solomon.coremon.meta.mem.MemOnlyMetricsCollection;

public interface MetabaseShardStorage {
    MetricsCollection<CoremonMetric> getFileMetrics();

    // takes ownership of newMetrics
    CompletableFuture<Void> write(CoremonMetricArray newMetrics);

    CompletableFuture<Void> write(
            Collection<CoremonMetric> updatedMetrics,
            Collection<? extends MetricMeta> newMetrics,
            Multimap<String, ? extends MetricMeta> newAggregates
    );

    long getWriteQueueMetrics();

    CompletableFuture<Void> reload();

    long getEstimatedRowsTotal();

    long getRowsLoaded();

    Throwable getLastLoadException();

    MemOnlyMetricsCollection getMemOnlyMetrics();
}
