package ru.yandex.solomon.coremon.meta.db;

import java.util.Collection;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.coremon.meta.CoremonMetricArray;


/**
 * @author Sergey Polovko
 */
public interface MetricsDao {

    CompletableFuture<Void> createSchema();
    CompletableFuture<Void> dropSchema();

    CompletableFuture<Long> getMetricCount();

    /**
     * Find all metrics and send them chunk by chunk to a consumer.
     *
     * @param consumer      consumer which accepts metrics
     * @param metricCount   hint about total metric count, can be empty if not known by a caller
     * @return total number of metrics that were found
     */
    CompletableFuture<Long> findMetrics(Consumer<CoremonMetricArray> consumer, OptionalLong metricCount);

    /**
     * Blindly inserts given metrics into table.
     * return metrics which didn't exists in table before insert
     */
    CompletableFuture<CoremonMetricArray> replaceMetrics(CoremonMetricArray metrics);

    /**
     * Delete metrics by given keys.
     */
    CompletableFuture<Void> deleteMetrics(Collection<Labels> keys);

    /**
     * Delete chunk of metrics and return amount
     */
    CompletableFuture<Long> deleteMetricsBatch();
}
