package ru.yandex.solomon.coremon.meta.db;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.selfmon.counters.AsyncMetrics;


/**
 * @author Sergey Polovko
 */
public final class MetricsDaoStats {
    public final Histogram readTimeMillis;
    public final Histogram writeTimeMillis;
    public final Histogram deleteTimeMillis;

    public final Rate readsCount;
    public final Rate insertsCount;
    public final Rate deletesCount;
    public final AsyncMetrics selects;
    public final AsyncMetrics readTables;

    public MetricsDaoStats(MetricRegistry registry, String type) {
        this(registry, Labels.of("type", type));
    }

    public MetricsDaoStats(MetricRegistry registry) {
        this(registry, Labels.empty());
    }

    public MetricsDaoStats(MetricRegistry registry, Labels labels) {
        String prefix = "metabase.db.";
        this.readTimeMillis = registry.histogramRate(prefix + "readTimeMillis", labels, Histograms.exponential(13, 2, 16));
        this.writeTimeMillis = registry.histogramRate(prefix + "writeTimeMillis", labels, Histograms.exponential(13, 2, 16));
        this.deleteTimeMillis = registry.histogramRate(prefix + "deleteTimeMillis", labels, Histograms.exponential(13, 2, 16));
        this.readsCount = registry.rate(prefix + "reads", labels);
        this.insertsCount = registry.rate(prefix + "inserts", labels);
        this.deletesCount = registry.rate(prefix + "deletes", labels);
        this.selects = new AsyncMetrics(registry, prefix + "selects", labels);
        this.readTables = new AsyncMetrics(registry, prefix + "readTables", labels);
    }
}
