package ru.yandex.solomon.coremon.meta.db;

import it.unimi.dsi.fastutil.HashCommon;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.stockpile.client.StockpileClient;
import ru.yandex.stockpile.client.shard.StockpileLocalId;
import ru.yandex.stockpile.client.shard.StockpileMetricId;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileMetricIdProviderHash implements StockpileMetricIdProvider {
    private final ShardIdToAtomicInteger stats;
    private final StockpileClient stockpileClient;

    public StockpileMetricIdProviderHash(ShardIdToAtomicInteger stats, StockpileClient stockpileClient) {
        this.stats = stats;
        this.stockpileClient = stockpileClient;
    }

    public int shardId(Labels labels) {
        int shardCount = stockpileClient.getTotalShardsCount();
        if (shardCount == 0) {
            throw new IllegalStateException("Unknown stockpile shard count");
        }

        int shardId = 1 + (hash(labels) & (shardCount - 1));
        stats.incrementAndGet(shardId);
        return shardId;
    }

    @Override
    public StockpileMetricId metricId(Labels labels) {
        return new StockpileMetricId(shardId(labels), StockpileLocalId.random());
    }

    private static int hash(Labels labels) {
        return HashCommon.murmurHash3(labels.hashCode());
    }
}
