package ru.yandex.solomon.coremon.meta.db.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.MetricType;


/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
public class Flags {

    private static final int TYPE_UNKNOWN = 0x00;
    private static final int TYPE_DGAUGE = 0x01;
    private static final int TYPE_IGAUGE = 0x02;
    private static final int TYPE_COUNTER = 0x03;
    private static final int TYPE_RATE = 0x04;
    private static final int TYPE_HIST = 0x05;
    private static final int TYPE_HIST_RATE = 0x06;
    private static final int TYPE_DSUMMARY = 0x07;
    private static final int TYPE_ISUMMARY = 0x08;
    private static final int TYPE_LOG_HISTOGRAM = 0x09;
    private static final int TYPE_MASK = 0x3f; // up to 64 values


    public static int buildFlags(MetricType type) {
        return typeToInt(type);
    }

    public static MetricType readMetricType(int flags) {
        return intToType(flags);
    }

    private static int typeToInt(MetricType type) {
        switch (type) {
            case UNKNOWN: return TYPE_UNKNOWN;
            case DGAUGE: return TYPE_DGAUGE;
            case IGAUGE: return TYPE_IGAUGE;
            case COUNTER: return TYPE_COUNTER;
            case RATE: return TYPE_RATE;
            case HIST: return TYPE_HIST;
            case HIST_RATE: return TYPE_HIST_RATE;
            case DSUMMARY: return TYPE_DSUMMARY;
            case ISUMMARY: return TYPE_ISUMMARY;
            case LOG_HISTOGRAM: return TYPE_LOG_HISTOGRAM;
            default:
                throw new IllegalArgumentException("unknown metric type: " + type);
        }
    }

    private static MetricType intToType(int value) {
        switch (value & TYPE_MASK) {
            case TYPE_UNKNOWN: return MetricType.UNKNOWN;
            case TYPE_DGAUGE: return MetricType.DGAUGE;
            case TYPE_IGAUGE: return MetricType.IGAUGE;
            case TYPE_COUNTER: return MetricType.COUNTER;
            case TYPE_RATE: return MetricType.RATE;
            case TYPE_HIST: return MetricType.HIST;
            case TYPE_HIST_RATE: return MetricType.HIST_RATE;
            case TYPE_DSUMMARY: return MetricType.DSUMMARY;
            case TYPE_ISUMMARY: return MetricType.ISUMMARY;
            case TYPE_LOG_HISTOGRAM: return MetricType.LOG_HISTOGRAM;
            default:
                return MetricType.UNKNOWN;
        }
    }
}
