package ru.yandex.solomon.coremon.meta.db.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.LabelAllocator;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.labels.LabelsBuilder;
import ru.yandex.solomon.util.Escaper;
import ru.yandex.solomon.util.parser.ParserSupport;

/**
 * Format is : "&key1=value1&key2=value2&...&" ("&" for an empty input)
 * Special characters are: '=', '&', '\'
 * Special characters in key and value are escaped by a prepended '\'
 * Leading and trailing ampersands are required to perform sear
 *
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class LabelListSortedSerialize {

    static final String SENTINEL = "~"; // ord('~') = 126

    private static final char ESCAPE_CHAR = '\\';
    private static final Escaper ESCAPER = new Escaper("=&", ESCAPE_CHAR);

    private LabelListSortedSerialize() {
    }

    public static Labels parse(String string) {
        return parse(string, Labels.allocator);
    }

    public static Labels parse(String string, LabelAllocator labelAllocator) {
        return parse(string, Labels.builder(7, labelAllocator));
    }

    public static Labels parse(String string, LabelsBuilder builder) {
        ParserSupport parser = new ParserSupport(string);
        parser.consume('&'); // Leading
        while (parser.hasNext()) {
            String key = ESCAPER.consumeUntil(parser, '=');
            parser.consume('=');
            String value = ESCAPER.consumeUntil(parser, '&');
            parser.consume('&');
            builder.add(key, value);
        }

        return builder.build();
    }

    public static String format(Labels labels) {
        StringBuilder result = new StringBuilder(256);
        result.append('&');
        labels.forEach(label -> {
            ESCAPER.escapeTo(label.getKey(), result);
            result.append('=');
            ESCAPER.escapeTo(label.getValue(), result);
            result.append('&');
        });
        return result.toString();
    }

}
