package ru.yandex.solomon.coremon.meta.db.ydb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.yandex.ydb.table.values.ListType;
import com.yandex.ydb.table.values.PrimitiveType;
import com.yandex.ydb.table.values.PrimitiveValue;
import com.yandex.ydb.table.values.StructType;
import com.yandex.ydb.table.values.Value;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.coremon.meta.CoremonMetricArray;


/**
 * @author Sergey Polovko
 */
final class MetricConverter {
    private MetricConverter() {}

    /**
     * V2 (huge tables)
     */
    interface V2 {
        StructType METRIC_TYPE = StructType.of(Map.of(
            "shardId", PrimitiveType.uint32(),
            "hash", PrimitiveType.uint32(),
            "labels", PrimitiveType.utf8(),
            "spShardId", PrimitiveType.uint32(),
            "spLocalId", PrimitiveType.uint64(),
            "createdAt", PrimitiveType.uint64(),
            "flags", PrimitiveType.uint32()
        ));

        ListType METRICS_LIST_TYPE = ListType.of(METRIC_TYPE);

        StructType KEY_TYPE = StructType.of(Map.of(
            "shardId", PrimitiveType.uint32(),
            "hash", PrimitiveType.uint32(),
            "labels", PrimitiveType.utf8()
        ));

        ListType KEYS_LIST_TYPE = ListType.of(KEY_TYPE);
    }

    static List<Value> metricsToValues(int shardId, CoremonMetricArray metrics) {
        ArrayList<Value> values = new ArrayList<>(metrics.size());
        for (int i = 0; i < metrics.size(); i++) {
            String labels = LabelListSortedSerialize.format(metrics.getLabels(i));
            int hash = labels.hashCode();
            int spShardId = metrics.getShardId(i);
            long spLocalId = metrics.getLocalId(i);
            int createdAt = metrics.getCreatedAtSeconds(i);
            int flags = Flags.buildFlags(metrics.getType(i));

            // NOTE: unsafe construction, do not modify order of parameters!
            values.add(V2.METRIC_TYPE.newValueUnsafe(
                PrimitiveValue.uint64(createdAt),
                PrimitiveValue.uint32(flags),
                PrimitiveValue.uint32(hash),
                PrimitiveValue.utf8(labels),
                PrimitiveValue.uint32(shardId),
                PrimitiveValue.uint64(spLocalId),
                PrimitiveValue.uint32(spShardId)
            ));
        }
        return values;
    }

    static Value keysToList(int shardId, Collection<Labels> keys) {
        return V2.KEYS_LIST_TYPE.newValue(keys.stream()
            .map(labels -> {
                String labelsStr = LabelListSortedSerialize.format(labels);
                // NOTE: unsafe construction, do not modify order of parameters!
                return V2.KEY_TYPE.newValueUnsafe(
                    PrimitiveValue.uint32(labelsStr.hashCode()),
                    PrimitiveValue.utf8(labelsStr),
                    PrimitiveValue.uint32(shardId));
            })
            .collect(Collectors.toList()));
    }
}
