package ru.yandex.solomon.coremon.meta.db.ydb;

import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.TKikimrClientConfig;
import ru.yandex.solomon.coremon.meta.db.DeletedMetricsDao;
import ru.yandex.solomon.selfmon.mon.DaoMetricsProxy;


/**
 * @author Stanislav Kashirin
 */
@Configuration
public class YdbDeletedMetricsDaoContext {

    @Bean
    DeletedMetricsDao deletedMetricsDao(
        @Qualifier("KikimrClientConfig") TKikimrClientConfig config,
        @Qualifier("localTableClient") TableClient tableClient,
        MetricRegistry registry)
    {
        var path = config.getSchemaRoot() + "/V1";

        var dao = new YdbDeletedMetricsDao(tableClient, path);
        return DaoMetricsProxy.of(dao, DeletedMetricsDao.class, registry);
    }
}
