package ru.yandex.solomon.coremon.meta.db.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
class YdbDeletedMetricsQuery {

    //language=SQL
    private static final String DELETE = """
             --!syntax_v1
             DECLARE $keys AS KEYS_LIST_TYPE;
             DELETE FROM `TABLE_PATH` ON SELECT * FROM AS_TABLE($keys);
             """;

    //language=SQL
    private static final String DELETE_BATCH = """
             --!syntax_v1
             DECLARE $operationId as Utf8;
             DECLARE $shardId as Uint32;

             $to_delete = (
                SELECT operationId, shardId, hash, labels
                FROM `TABLE_PATH`
                WHERE operationId = $operationId AND shardId = $shardId
                LIMIT 5000
             );

             SELECT cast(count(*) as Uint64) FROM $to_delete;

             DELETE FROM `TABLE_PATH` ON
             SELECT * FROM $to_delete;
             """;

    //language=SQL
    private static final String COUNT = """
             --!syntax_v1
             DECLARE $operationId as Utf8;
             DECLARE $shardId as Uint32;

             SELECT cast(count(*) as Uint64)
             FROM `TABLE_PATH`
             WHERE operationId = $operationId AND shardId = $shardId;
             """;

    final String tablePath;

    final String delete;
    final String deleteBatch;
    final String count;

    YdbDeletedMetricsQuery(String root) {
        this.tablePath = root + "/" + YdbDeletedMetricsTable.TABLE_NAME;

        this.delete = prepare(DELETE);
        this.deleteBatch = prepare(DELETE_BATCH);
        this.count = prepare(COUNT);
    }

    private String prepare(String query) {
        return query
            .replaceAll("KEYS_LIST_TYPE", YdbDeletedMetricsTable.KEYS_LIST_TYPE.toString())
            .replaceAll("TABLE_PATH", tablePath);
    }
}
