package ru.yandex.solomon.coremon.meta.db.ydb;

import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.TKikimrClientConfig;
import ru.yandex.solomon.coremon.meta.db.MetricsDaoFactory;


/**
 * @author Sergey Polovko
 */
@Configuration
public class YdbMetricsDaoContext {

    @Bean
    MetricsDaoFactory metricsDaoFactory(
        @Qualifier("KikimrClientConfig") TKikimrClientConfig config,
        @Qualifier("localTableClient") TableClient tableClient,
        MetricRegistry registry)
    {
        var path = config.getSchemaRoot() + "/V1";
        return YdbMetricsDaoFactory.forReadWrite(tableClient, path, registry);
    }
}
