package ru.yandex.solomon.coremon.meta.db.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.ydb.table.TableClient;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.monlib.metrics.labels.LabelAllocator;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.coremon.meta.db.MetricsDao;
import ru.yandex.solomon.coremon.meta.db.MetricsDaoFactory;
import ru.yandex.solomon.coremon.meta.db.MetricsDaoStats;
import ru.yandex.solomon.selfmon.mon.DaoMetricsProxy;


/**
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
public class YdbMetricsDaoFactory implements MetricsDaoFactory {

    private final TableClient tableClient;
    private final String path;
    private final MetricsDaoStats stats;
    private final MetricRegistry registry;

    private YdbMetricsDaoFactory(
        TableClient tableClient,
        String path,
        MetricRegistry metricRegistry)
    {
        this.tableClient = tableClient;
        this.path = StringUtils.removeEnd(path, "/");
        this.stats = new MetricsDaoStats(metricRegistry);
        this.registry = metricRegistry;
    }

    public static YdbMetricsDaoFactory forReadWrite(TableClient tableClient, String path, MetricRegistry registry) {
        return new YdbMetricsDaoFactory(tableClient, path, registry);
    }

    public static YdbMetricsDaoFactory forReadOnly(TableClient tableClient, String path) {
        return new YdbMetricsDaoFactory(tableClient, path, MetricRegistry.root());
    }

    @Override
    public MetricsDao create(int numId, LabelAllocator labelAllocator) {
        var dao = new YdbMetricsHugeTableDao(tableClient, numId, path, stats, labelAllocator);
        return DaoMetricsProxy.of(dao, MetricsDao.class, registry);
    }
}
