package ru.yandex.solomon.coremon.meta.file;

import java.util.NoSuchElementException;

import ru.yandex.solomon.coremon.meta.CoremonMetric;
import ru.yandex.solomon.util.collection.CloseableIterator;


/**
 * @author Sergey Polovko
 */
final class IteratorImpl implements CloseableIterator<CoremonMetric> {
    private final LevelsArray levels;
    private int levelIdx = 0;
    private int metricIdx = 0;

    IteratorImpl(LevelsArray levels) {
        this.levels = levels;
        skipEmptyLevels();
    }

    @Override
    public boolean hasNext() {
        return levelIdx < levels.count() && metricIdx < currentLevel().size();
    }

    @Override
    public CoremonMetric next() {
        if (!hasNext()) {
            throw new NoSuchElementException();
        }

        final Level level = currentLevel();
        final CoremonMetric metric = level.getMetricByIndex(metricIdx++);

        if (metricIdx == level.size()) {
            metricIdx = 0;
            levelIdx++;
            skipEmptyLevels();
        }
        return metric;
    }

    private void skipEmptyLevels() {
        while (levelIdx < levels.count() && currentLevel().size() == 0) {
            levelIdx++;
        }
    }

    private Level currentLevel() {
        return levels.getLevel(levelIdx);
    }

    @Override
    public void close() {
        levels.close();
    }
}
