package ru.yandex.solomon.coremon.meta.file;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;


/**
 * Extends from CompletableFuture to reduce allocations a little bit
 *
 * @author Sergey Polovko
 */
final class RemoveRequest extends CompletableFuture<Void> implements MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(RemoveRequest.class);

    private final Labels[] keys;

    // for tests only
    RemoveRequest(Labels... keys) {
        this.keys = keys;
    }

    RemoveRequest(Collection<Labels> keys) {
        // create copy to guaranty immutability
        this.keys = keys.toArray(new Labels[0]);
    }

    public Labels[] getKeys() {
        return keys;
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE + MemoryCounter.arrayObjectSize(keys);
    }
}
