package ru.yandex.solomon.coremon.meta.file;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.coremon.meta.CoremonMetric;
import ru.yandex.solomon.coremon.meta.CoremonMetricArray;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;


/**
 * Extends from CompletableFuture to reduce allocations a little bit
 *
 * @author Sergey Polovko
 */
final class UpdateRequest extends CompletableFuture<Void> implements MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(UpdateRequest.class);

    // CoremonMetricArray or CoremonMetric
    private Object metrics;

    UpdateRequest(CoremonMetricArray metrics) {
        // create copy to guaranty immutability
        this.metrics = new CoremonMetricArray(metrics);
    }

    UpdateRequest(CoremonMetric metric) {
        // create copy to guaranty immutability
        this.metrics = metric;
    }

    public boolean isMany() {
        return metrics instanceof CoremonMetricArray;
    }

    public CoremonMetricArray getMetrics() {
        return (CoremonMetricArray) metrics;
    }

    public CoremonMetric getMetric() {
        return (CoremonMetric) metrics;
    }

    public int size() {
        return isMany() ? getMetrics().size() : 1;
    }

    public void release() {
        if (metrics instanceof CoremonMetricArray) {
            ((CoremonMetricArray) metrics).close();
        }
        metrics = null;
    }

    @Override
    public long memorySizeIncludingSelf() {
        long size = SELF_SIZE;
        if (isMany()) {
            size += getMetrics().memorySizeIncludingSelf();
        } else {
            size += getMetric().memorySizeIncludingSelf();
        }
        return size;
    }
}
