package ru.yandex.solomon.coremon.meta.mem;

import javax.annotation.Nullable;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.coremon.meta.CoremonMetric;
import ru.yandex.solomon.memory.layout.MemoryCounter;


/**
 * @author Sergey Polovko
 */
public class MemOnlyCoremonMetric implements CoremonMetric {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(MemOnlyCoremonMetric.class);

    private Labels labels = Labels.empty();
    @Nullable
    private Object aggrMetrics;

    @Override
    public int getShardId() {
        throw new UnsupportedOperationException("trying to get shardId from mem only metric");
    }

    @Override
    public long getLocalId() {
        throw new UnsupportedOperationException("trying to get localId from mem only metric");
    }

    @Override
    public MetricType getType() {
        return MetricType.UNKNOWN;
    }

    @Override
    public int getCreatedAtSeconds() {
        return 0;
    }

    @Override
    public Labels getLabels() {
        return labels;
    }

    public void setLabels(Labels labels) {
        assert labels != null;
        this.labels = labels;
    }

    @Nullable
    @Override
    public Object getAggrMetrics() {
        return aggrMetrics;
    }

    @Override
    public void setAggrMetrics(Object aggrMetrics) {
        this.aggrMetrics = aggrMetrics;
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE;
    }

    @Override
    public void setType(MetricType type) {
        throw new UnsupportedOperationException("trying to set type on mem only metric");
    }

    @Override
    public boolean isMemOnly() {
        return true;
    }

    @Override
    public void close() {
        labels = Labels.empty();
        aggrMetrics = null;
    }

    @Override
    public int getLastPointSeconds() {
        throw new UnsupportedOperationException("trying to get lastPointSeconds from mem only metric");
    }

    @Override
    public void setLastPointSeconds(int lastPointSeconds) {
        throw new UnsupportedOperationException("trying to set lastPointSeconds on mem only metric");
    }
}
