package ru.yandex.solomon.coremon.meta.service;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.coremon.meta.service.cloud.ReferenceResolver;
import ru.yandex.solomon.coremon.meta.service.cloud.ResourceFinder;
import ru.yandex.solomon.coremon.meta.service.handler.CreateManyHandler;
import ru.yandex.solomon.coremon.meta.service.handler.CreateOneHandler;
import ru.yandex.solomon.coremon.meta.service.handler.DeleteManyHandler;
import ru.yandex.solomon.coremon.meta.service.handler.FindHandler;
import ru.yandex.solomon.coremon.meta.service.handler.LabelNamesHandler;
import ru.yandex.solomon.coremon.meta.service.handler.LabelValuesHandler;
import ru.yandex.solomon.coremon.meta.service.handler.MetricNamesHandler;
import ru.yandex.solomon.coremon.meta.service.handler.ResolveLogsHandler;
import ru.yandex.solomon.coremon.meta.service.handler.ResolveManyHandler;
import ru.yandex.solomon.coremon.meta.service.handler.ResolveOneHandler;
import ru.yandex.solomon.coremon.meta.service.handler.ServerStatusHandler;
import ru.yandex.solomon.coremon.meta.service.handler.UniqueLabelsHandler;
import ru.yandex.solomon.metabase.api.protobuf.CreateManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.CreateManyResponse;
import ru.yandex.solomon.metabase.api.protobuf.CreateOneRequest;
import ru.yandex.solomon.metabase.api.protobuf.CreateOneResponse;
import ru.yandex.solomon.metabase.api.protobuf.DeleteManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.DeleteManyResponse;
import ru.yandex.solomon.metabase.api.protobuf.FindRequest;
import ru.yandex.solomon.metabase.api.protobuf.FindResponse;
import ru.yandex.solomon.metabase.api.protobuf.MetricNamesRequest;
import ru.yandex.solomon.metabase.api.protobuf.MetricNamesResponse;
import ru.yandex.solomon.metabase.api.protobuf.ResolveManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.ResolveManyResponse;
import ru.yandex.solomon.metabase.api.protobuf.ResolveOneRequest;
import ru.yandex.solomon.metabase.api.protobuf.ResolveOneResponse;
import ru.yandex.solomon.metabase.api.protobuf.TLabelNamesRequest;
import ru.yandex.solomon.metabase.api.protobuf.TLabelNamesResponse;
import ru.yandex.solomon.metabase.api.protobuf.TLabelValuesRequest;
import ru.yandex.solomon.metabase.api.protobuf.TLabelValuesResponse;
import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsRequest;
import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsResponse;
import ru.yandex.solomon.metabase.api.protobuf.TServerStatusRequest;
import ru.yandex.solomon.metabase.api.protobuf.TServerStatusResponse;
import ru.yandex.solomon.metabase.api.protobuf.TUniqueLabelsRequest;
import ru.yandex.solomon.metabase.api.protobuf.TUniqueLabelsResponse;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class CrossShardMetabaseService implements MetabaseService {
    private final MetabaseShardResolver shardResolver;
    private final ReferenceResolver referenceResolver;
    private final ResourceFinder resourceFinder;

    public CrossShardMetabaseService(MetabaseShardResolver shardResolver, ReferenceResolver referenceResolver, ResourceFinder resourceFinder) {
        this.shardResolver = shardResolver;
        this.referenceResolver = referenceResolver;
        this.resourceFinder = resourceFinder;
    }

    @Override
    public CompletableFuture<TServerStatusResponse> serverStatus(TServerStatusRequest request) {
        return new ServerStatusHandler(shardResolver).serverStatus(request);
    }

    @Override
    public CompletableFuture<CreateOneResponse> createOne(CreateOneRequest request) {
        return new CreateOneHandler(shardResolver).createOne(request);
    }

    @Override
    public CompletableFuture<CreateManyResponse> createMany(CreateManyRequest request) {
        return new CreateManyHandler(shardResolver).createMany(request);
    }

    @Override
    public CompletableFuture<ResolveOneResponse> resolveOne(ResolveOneRequest request) {
        return new ResolveOneHandler(shardResolver, referenceResolver, resourceFinder).resolveOne(request);
    }

    @Override
    public CompletableFuture<ResolveManyResponse> resolveMany(ResolveManyRequest request) {
        return new ResolveManyHandler(shardResolver).resolveMany(request);
    }

    @Override
    public CompletableFuture<DeleteManyResponse> deleteMany(DeleteManyRequest request) {
        return new DeleteManyHandler(shardResolver).deleteMany(request);
    }

    @Override
    public CompletableFuture<FindResponse> find(FindRequest request) {
        return new FindHandler(shardResolver, referenceResolver, resourceFinder).find(request);
    }

    @Override
    public CompletableFuture<MetricNamesResponse> metricNames(MetricNamesRequest request) {
        return new MetricNamesHandler(shardResolver, referenceResolver, resourceFinder).metricNames(request);
    }

    @Override
    public CompletableFuture<TLabelValuesResponse> labelValues(TLabelValuesRequest request) {
        return new LabelValuesHandler(shardResolver, referenceResolver, resourceFinder).labelValues(request);
    }

    @Override
    public CompletableFuture<TLabelNamesResponse> labelNames(TLabelNamesRequest request) {
        return new LabelNamesHandler(shardResolver, referenceResolver, resourceFinder).labelNames(request);
    }

    @Override
    public CompletableFuture<TUniqueLabelsResponse> uniqueLabels(TUniqueLabelsRequest request) {
        return new UniqueLabelsHandler(shardResolver, referenceResolver, resourceFinder).uniqueLabels(request);
    }

    @Override
    public CompletableFuture<TResolveLogsResponse> resolveLogs(TResolveLogsRequest request) {
        return new ResolveLogsHandler(shardResolver).resolveLogs(request);
    }
}
