package ru.yandex.solomon.coremon.meta.service;

import java.util.Optional;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;

import io.grpc.Server;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.grpc.utils.GrpcServerFactory;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.rpc.TGrpcServerConfig;
import ru.yandex.solomon.core.grpc.GrpcContext;
import ru.yandex.solomon.coremon.meta.service.cloud.EmptyReferenceResolver;
import ru.yandex.solomon.coremon.meta.service.cloud.EmptyResourceFinder;
import ru.yandex.solomon.coremon.meta.service.cloud.ReferenceResolver;
import ru.yandex.solomon.coremon.meta.service.cloud.ResourceFinder;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
@ParametersAreNonnullByDefault
@Import({
    GrpcContext.class
})
public class MetabaseGrpcServerContext implements DisposableBean {

    private final GrpcServerFactory grpcServerFactory;

    @WillClose
    @Nullable
    private Server server;

    @Autowired
    public MetabaseGrpcServerContext(GrpcServerFactory grpcServerFactory) {
        this.grpcServerFactory = grpcServerFactory;
    }

    @Bean
    public MetabaseService localMetabaseService(MetabaseShardResolver shardResolver, Optional<ReferenceResolver> referenceResolver, Optional<ResourceFinder> resourceFinder) {
        return new CrossShardMetabaseService(shardResolver,
                referenceResolver.orElseGet(EmptyReferenceResolver::new),
                resourceFinder.orElseGet(EmptyResourceFinder::new));
    }

    @Bean
    public Server metabaseGrpcServer(TGrpcServerConfig config, GrpcMetabaseService grpcMetabaseService) {
        server = grpcServerFactory.makeServer(
                "GrpcServerConfig",
                config,
                grpcMetabaseService);
        grpcServerFactory.startWithTimeout(config, server);
        return server;
    }

    @Bean
    public GrpcMetabaseService grpcMetabaseService(MetabaseService metabaseService, MetricRegistry registry) {
        return new GrpcMetabaseService(metabaseService, registry);
    }

    @Override
    public void destroy() {
        Server server = this.server;
        if (server != null) {
            server.shutdown();
        }
    }
}
