package ru.yandex.solomon.coremon.meta.service;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.metabase.api.protobuf.CreateManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.CreateManyResponse;
import ru.yandex.solomon.metabase.api.protobuf.CreateOneRequest;
import ru.yandex.solomon.metabase.api.protobuf.CreateOneResponse;
import ru.yandex.solomon.metabase.api.protobuf.DeleteManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.DeleteManyResponse;
import ru.yandex.solomon.metabase.api.protobuf.FindRequest;
import ru.yandex.solomon.metabase.api.protobuf.FindResponse;
import ru.yandex.solomon.metabase.api.protobuf.MetricNamesRequest;
import ru.yandex.solomon.metabase.api.protobuf.MetricNamesResponse;
import ru.yandex.solomon.metabase.api.protobuf.ResolveManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.ResolveManyResponse;
import ru.yandex.solomon.metabase.api.protobuf.ResolveOneRequest;
import ru.yandex.solomon.metabase.api.protobuf.ResolveOneResponse;
import ru.yandex.solomon.metabase.api.protobuf.TLabelNamesRequest;
import ru.yandex.solomon.metabase.api.protobuf.TLabelNamesResponse;
import ru.yandex.solomon.metabase.api.protobuf.TLabelValuesRequest;
import ru.yandex.solomon.metabase.api.protobuf.TLabelValuesResponse;
import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsRequest;
import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsResponse;
import ru.yandex.solomon.metabase.api.protobuf.TServerStatusRequest;
import ru.yandex.solomon.metabase.api.protobuf.TServerStatusResponse;
import ru.yandex.solomon.metabase.api.protobuf.TUniqueLabelsRequest;
import ru.yandex.solomon.metabase.api.protobuf.TUniqueLabelsResponse;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public interface MetabaseService {

    // remove it
    CompletableFuture<TServerStatusResponse> serverStatus(TServerStatusRequest request);

    // (TDeferredOperationId, dl) -> (Status, Delete: { CurrentDeletedCount, EstimatedCount }   )

    // (Label[], kind, deadline) -> Metric(stockpileId, meta)
    CompletableFuture<CreateOneResponse> createOne(CreateOneRequest request);

    CompletableFuture<CreateManyResponse> createMany(CreateManyRequest request);

    // (TLabels, deadline) -> TStockpileId
    CompletableFuture<ResolveOneResponse> resolveOne(ResolveOneRequest request);

    // (TLabels[], deadline) -> TStockpileId
    CompletableFuture<ResolveManyResponse> resolveMany(ResolveManyRequest request);

    // (bytes, deadline) -> {pos => TStockpileId[]}
    // CompletableFuture<ResolveManyResponse> upsertInternal(ResolveManyRequest request);

    // (TSelector, deadline) -> TDeferredResult
    CompletableFuture<DeleteManyResponse> deleteMany(DeleteManyRequest request);

    // (TSelectors, deadline) -> TStockpileId[]
    CompletableFuture<FindResponse> find(FindRequest request);

    CompletableFuture<MetricNamesResponse> metricNames(MetricNamesRequest request);

    CompletableFuture<TLabelValuesResponse> labelValues(TLabelValuesRequest request);

    CompletableFuture<TLabelNamesResponse> labelNames(TLabelNamesRequest request);

    CompletableFuture<TUniqueLabelsResponse> uniqueLabels(TUniqueLabelsRequest request);

    CompletableFuture<TResolveLogsResponse> resolveLogs(TResolveLogsRequest request);
}
