package ru.yandex.solomon.coremon.meta.service;

import java.util.concurrent.CompletableFuture;

import ru.yandex.monitoring.coremon.EShardState;
import ru.yandex.monlib.metrics.labels.LabelAllocator;
import ru.yandex.solomon.core.db.model.ShardState;
import ru.yandex.solomon.coremon.meta.db.MetabaseShardStorage;
import ru.yandex.solomon.coremon.meta.mem.MemOnlyMetricsCollection;
import ru.yandex.solomon.labels.shard.ShardKey;
import ru.yandex.solomon.memory.layout.MemoryBySubsystem;

public interface MetabaseShard {

    // conf db
    String getId();
    int getNumId();
    String getFolderId();
    int getNumPartitions();
    String getServiceProvider();
    ShardKey getShardKey();

    LabelAllocator getLabelAllocator();
    MetabaseShardStorage getStorage();
    MemOnlyMetricsCollection getMemOnlyMetrics();
    MetabaseShardMetrics getMetrics();
    void addMemoryInfo(MemoryBySubsystem r);

    int fileMetricsCount();
    int maxFileMetrics();
    int fileAndMemOnlyMetrics();
    default boolean reachFileMetricsQuota() {
        return fileMetricsCount() >= maxFileMetrics();
    }

    CompletableFuture<Void> getLoadFuture();
    boolean isLoaded();
    long getUptimeMillis();
    EShardState getState();

    // Shard opts
    void setMetricNameLabel(String metricNameLabel);
    void setOnlyNewFormatWrites(boolean onlyNewFormatWrites);
    void setOnlyNewFormatReads(boolean onlyNewFormatReads);
    void setServiceProvider(String serviceProvider);
    void setShardState(ShardState shardState);
    void setMaxFileMetrics(int maxFileMetrics);

    void stop();
}
