package ru.yandex.solomon.coremon.meta.service;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.labels.shard.ShardKey;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class MetabaseShardConf {

    private final int numId;
    private final String folderId;
    private final ShardKey shardKey;
    private final String metricName;
    private final int numPartitions;

    private MetabaseShardConf(int numId, String folderId, ShardKey shardKey, String metricName, int numPartitions) {
        this.numId = numId;
        this.folderId = folderId;
        this.shardKey = shardKey;
        this.metricName = metricName;
        this.numPartitions = numPartitions;
    }

    public static MetabaseShardConf of(String project, String folder, String cluster, String service, int numId, int numPartitions) {
        return new MetabaseShardConf(numId, folder, new ShardKey(project, cluster, service), "", numPartitions);
    }

    public static MetabaseShardConf of(
        String project,
        String folder,
        String cluster,
        String service,
        String metricName,
        int numId,
        int numPartitions)
    {
        return new MetabaseShardConf(numId, folder, new ShardKey(project, cluster, service), metricName, numPartitions);
    }

    public String getMetricName() {
        return metricName;
    }

    public String getFolderId() {
        return folderId;
    }

    public ShardKey getShardKey() {
        return shardKey;
    }

    public int getNumId() {
        return numId;
    }

    public int getNumPartitions() {
        return numPartitions;
    }
}
