package ru.yandex.solomon.coremon.meta.service;

import java.util.stream.Stream;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.labels.shard.ShardKey;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public interface MetabaseShardResolver<T extends MetabaseShard> extends MetabaseTotalShardCounter {

    boolean isLoading();

    T resolveShard(ShardKey shardKey);

    @Nullable
    T resolveShardOrNull(int numId);

    T resolveShard(int numId);

    Stream<T> resolveShard(String folderId, Selectors shardSelector);

    long getShardKeysHash();

    Stream<T> getShards();

    int getInactiveShardCount();
}
