package ru.yandex.solomon.coremon.meta.service;

import io.grpc.Status;

import ru.yandex.monlib.metrics.labels.Label;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.labels.LabelsBuilder;
import ru.yandex.solomon.labels.LabelKeys;
import ru.yandex.solomon.labels.shard.ShardKey;

/**
 * @author Vladimir Gordiychuk
 */
public class ShardKeyAndMetricKey {
    private final ShardKey shardKey;
    private final Labels metricKey;

    ShardKeyAndMetricKey(ShardKey shardKey, Labels metricKey) {
        this.shardKey = shardKey;
        this.metricKey = metricKey;
    }

    public static ShardKeyAndMetricKey of(Labels labels) {
        if (labels.size() < 3) {
            throw Status.INVALID_ARGUMENT.withDescription("there is no shard key in labels: " + labels).asRuntimeException();
        }

        String project = null;
        String cluster = null;
        String service = null;

        LabelsBuilder withoutShardLabels = Labels.builder(labels.size() - 3);

        for (int i = 0; i < labels.size(); i++) {
            final Label label = labels.at(i);
            final String key = label.getKey();
            if (LabelKeys.PROJECT.equals(key)) {
                project = label.getValue();
            } else if (LabelKeys.CLUSTER.equals(key)) {
                cluster = label.getValue();
            } else if (LabelKeys.SERVICE.equals(key)) {
                service = label.getValue();
            } else {
                withoutShardLabels.add(label);
            }
        }

        if (project == null || cluster == null || service == null) {
            throw Status.INVALID_ARGUMENT.withDescription("there is no shard key in labels: " + labels).asRuntimeException();
        }

        ShardKey shardKey = new ShardKey(project, cluster, service);
        Labels metricKey = withoutShardLabels.build();
        return new ShardKeyAndMetricKey(shardKey, metricKey);
    }

    public ShardKey getShardKey() {
        return shardKey;
    }

    public Labels getMetricKey() {
        return metricKey;
    }

    @Override
    public String toString() {
        return "{shardKey=" + shardKey + ", metricKey=" + metricKey + '}';
    }
}
