package ru.yandex.solomon.coremon.meta.service.cloud;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.labels.query.Selectors;

/**
 * @author Vladimir Gordiychuk
 */
public class EmptyResourceFinder implements ResourceFinder {
    @Override
    public CompletableFuture<Map<String, ResourceMap>> find(String cloudId, Map<String, Selectors> selectorsByLabel, long expiredAt) {
        return CompletableFuture.completedFuture(Map.of());
    }

    @Override
    public CompletableFuture<ResourceMap> resolve(String cloudId, Collection<String> resourceIds, long expiredAt) {
        return CompletableFuture.completedFuture(new ResourceMap(List.of()));
    }
}
