package ru.yandex.solomon.coremon.meta.service.cloud;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

import ru.yandex.misc.concurrent.CompletableFutures;
import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.name.resolver.client.FindRequest;
import ru.yandex.solomon.name.resolver.client.NameResolverClient;
import ru.yandex.solomon.name.resolver.client.ResolveRequest;

import static java.util.stream.Collectors.collectingAndThen;
import static java.util.stream.Collectors.toList;

/**
 * @author Vladimir Gordiychuk
 */
public class NameResolverResourceFinder implements ResourceFinder {
    private final NameResolverClient client;

    public NameResolverResourceFinder(NameResolverClient client) {
        this.client = client;
    }

    @Override
    public CompletableFuture<Map<String, ResourceMap>> find(String cloudId, Map<String, Selectors> selectorsByLabel, long expiredAt) {
        return  selectorsByLabel.entrySet().stream()
                .map(entry -> client.find(FindRequest.newBuilder()
                        .cloudId(cloudId)
                        .selectors(entry.getValue())
                        .expiredAt(expiredAt)
                        .build())
                        .thenApply(response -> new Result(entry.getKey(), new ResourceMap(response.resources))))
                .collect(collectingAndThen(toList(), CompletableFutures::allOf))
                .thenApply(list -> list.stream().collect(Collectors.toMap(Result::label, Result::resources)));
    }

    @Override
    public CompletableFuture<ResourceMap> resolve(String cloudId, Collection<String> resourceIds, long expiredAt) {
        return client.resolve(ResolveRequest.newBuilder()
                .cloudId(cloudId)
                .resourceIds(resourceIds)
                .expiredAt(expiredAt)
                .build())
                .thenApply(response -> new ResourceMap(response.resources));
    }

    private static record Result(String label, ResourceMap resources) { }
}
