package ru.yandex.solomon.coremon.meta.service.cloud;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Vladimir Gordiychuk
 */
public final record ReferenceLabel(String label, Set<String> types, Set<String> services, Set<String> folders) {

    public static Map<String, ReferenceLabel> toMap(Collection<ReferenceLabel> references) {
        Map<String, ReferenceLabel> result = new HashMap<>(references.size());
        for (var reference : references) {
            var prev = result.put(reference.label, reference);
            if (prev != null) {
                result.put(reference.label, combine(prev, reference));
            }
        }
        return result;
    }

    public static ReferenceLabel combine(ReferenceLabel left, ReferenceLabel right) {
        if (left.equals(right)) {
            return left;
        }

        var types = combineTypes(left, right);
        var services = combineServices(left, right);
        var folders = combineFolders(left, right);
        return new ReferenceLabel(left.label, types, services, folders);
    }

    private static Set<String> combineTypes(ReferenceLabel left, ReferenceLabel right) {
        return combineSet(left, right, ReferenceLabel::types);
    }

    private static Set<String> combineServices(ReferenceLabel left, ReferenceLabel right) {
        return combineSet(left, right, ReferenceLabel::services);
    }

    private static Set<String> combineFolders(ReferenceLabel left, ReferenceLabel right) {
        return combineSet(left, right, ReferenceLabel::folders);
    }

    private static Set<String> combineSet(ReferenceLabel left, ReferenceLabel right, Function<ReferenceLabel, Set<String>> fn) {
        if (fn.apply(left).isEmpty() || fn.apply(right).isEmpty()) {
            return Set.of();
        }

        return Stream.concat(fn.apply(left).stream(), fn.apply(right).stream())
                .collect(Collectors.toUnmodifiableSet());
    }
}
