package ru.yandex.solomon.coremon.meta.service.cloud;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.flags.FeatureFlag;
import ru.yandex.solomon.flags.FeatureFlagsHolder;

/**
 * @author Vladimir Gordiychuk
 */
public class ReferenceResolverImpl implements ReferenceResolver {
    private final FeatureFlagsHolder flags;
    private final SolomonConfHolder confs;

    public ReferenceResolverImpl(FeatureFlagsHolder flags, SolomonConfHolder confs) {
        this.flags = flags;
        this.confs = confs;
    }

    @Override
    public List<ReferenceLabel> resolve(int numId) {
        if (!flags.hasFlag(FeatureFlag.RESOURCE_NAME, numId)) {
            return List.of();
        }

        var conf = confs.getConfOrThrow();
        var shard = conf.getShardByNumId(numId).getConfOrThrow();
        var service = shard.getService();
        var serviceProvider = service.getServiceProvider();
        if (serviceProvider == null) {
            return List.of();
        }

        var referencesConf = serviceProvider.getReferences();
        if (referencesConf.isEmpty()) {
            return List.of();
        }

        List<ReferenceLabel> result = new ArrayList<>(referencesConf.size());
        for (var referenceConf : referencesConf) {
            var reference = new ReferenceLabel(
                    referenceConf.label,
                    Set.copyOf(referenceConf.types),
                    Set.copyOf(referenceConf.services),
                    referenceConf.crossFolder ? Set.of() : Set.of(shard.getCluster().getName()));
            result.add(reference);
        }
        return result;
    }
}
