package ru.yandex.solomon.coremon.meta.service.cloud;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.labels.query.Selectors;

/**
 * @author Vladimir Gordiychuk
 */
public interface ResourceFinder {
    CompletableFuture<Map<String, ResourceMap>> find(String cloudId, Map<String, Selectors> selectorsByLabel, long expiredAt);
    CompletableFuture<ResourceMap> resolve(String cloudId, Collection<String> resourceIds, long expiredAt);
}
