package ru.yandex.solomon.coremon.meta.service.cloud;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.annotation.Nullable;

import com.google.common.collect.Iterators;

import ru.yandex.solomon.name.resolver.client.Resource;

/**
 * @author Vladimir Gordiychuk
 */
public class ResourceMap extends AbstractCollection<Resource> {
    private final Map<String, Resource> resourceById;

    public ResourceMap(Collection<Resource> resources) {
        var map = new HashMap<String, Resource>();
        for (var resource : resources) {
            map.put(resource.resourceId, resource);
        }
        resourceById = map;
    }

    @Nullable
    public Resource getResourceById(String resourceId) {
        return resourceById.get(resourceId);
    }

    @Override
    public Iterator<Resource> iterator() {
        return Iterators.unmodifiableIterator(resourceById.values().iterator());
    }

    @Override
    public int size() {
        return resourceById.size();
    }
}
