package ru.yandex.solomon.coremon.meta.service.handler;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.coremon.meta.service.MetabaseShardImpl;
import ru.yandex.solomon.coremon.meta.service.MetabaseShardResolver;
import ru.yandex.solomon.coremon.meta.service.ShardKeyAndMetricKey;
import ru.yandex.solomon.labels.protobuf.LabelConverter;
import ru.yandex.solomon.metabase.api.protobuf.CreateManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.CreateManyResponse;
import ru.yandex.solomon.metabase.api.protobuf.EMetabaseStatusCode;

import static ru.yandex.solomon.coremon.meta.service.handler.MetabaseShards.ensureReadyToWrite;

/**
 * @author Vladimir Gordiychuk
 */
public class CreateManyHandler {
    private final MetabaseShardResolver<MetabaseShardImpl> shardResolver;

    public CreateManyHandler(MetabaseShardResolver<MetabaseShardImpl> shardResolver) {
        this.shardResolver = shardResolver;
    }

    public CompletableFuture<CreateManyResponse> createMany(CreateManyRequest request) {
        // cross shard not able for createMany
        final ShardKeyAndMetricKey commonLabels =
                ShardKeyAndMetricKey.of(LabelConverter.protoToLabels(request.getCommonLabelsList()));

        MetabaseShardImpl shard = shardResolver.resolveShard(commonLabels.getShardKey());
        ensureReadyToWrite(shard);

        final Labels shardLabels = commonLabels.getShardKey().toLabels();
        final Labels commonLabelsInsideShard = commonLabels.getMetricKey();
        return shard.createMetrics(commonLabelsInsideShard, request.getMetricsList())
                .thenApply(metrics -> CreateManyResponse.newBuilder()
                        .setStatus(EMetabaseStatusCode.OK)
                        .addAllMetrics(metrics.stream()
                                .map(metric -> Proto.toProto(metric, shardLabels))
                                .collect(Collectors.toList()))
                        .build());
    }
}
